<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Settings extends Model
{
    protected $fillable = [
        'company_name',
        'company_address',
        'company_phone',
        'company_contact',
        'company_logo',
        'currency_local_name',
        'currency_local_symbol',
        'currency_usd_name',
        'currency_usd_symbol',
        'exchange_rate',
        'idle_time_minutes',
        'auto_backup_enabled',
        'auto_backup_time',
        'backup_path',
    ];

    protected $casts = [
        'exchange_rate' => 'decimal:2',
        'idle_time_minutes' => 'integer',
        'auto_backup_enabled' => 'boolean',
    ];

    public static function getSettings()
    {
        $settings = self::first();
        
        if (!$settings) {
            $settings = self::create([
                'company_name' => 'DaInvent',
                'currency_local_name' => 'Peso',
                'currency_local_symbol' => '$',
                'currency_usd_name' => 'Dólar',
                'currency_usd_symbol' => '$',
                'exchange_rate' => 1,
                'idle_time_minutes' => 5,
            ]);
        }
        
        return $settings;
    }
}
