<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Role;

class RoleSeeder extends Seeder
{
    public function run(): void
    {
        $roles = [
            [
                'name' => 'Administrador',
                'slug' => 'admin',
                'description' => 'Usuario con acceso total al sistema',
                'is_active' => true,
            ],
            [
                'name' => 'Usuario',
                'slug' => 'user',
                'description' => 'Usuario regular con acceso limitado',
                'is_active' => true,
            ],
            [
                'name' => 'Vendedor',
                'slug' => 'seller',
                'description' => 'Usuario con acceso a ventas y facturación',
                'is_active' => true,
            ],
            [
                'name' => 'Almacenero',
                'slug' => 'warehouse',
                'description' => 'Usuario con acceso al gestión de inventario',
                'is_active' => true,
            ],
        ];

        foreach ($roles as $role) {
            Role::updateOrCreate(
                ['slug' => $role['slug']],
                $role
            );
        }
    }
}
